set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 6, panel C

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.

	*Construct hrs, wagebill, and laborshare excluding self-employed
	gen lnCOMP=ln(COMP)
	gen lnEMPE=ln(EMPE)
	gen lnH_EMPE=ln(H_EMPE)
	
	drop D1_lnEMP D1_lnH_EMP D1_lnhwage D1_lnLAB D1_lnlaborshare lnlaborshare
	gen lnlaborshare=ln(COMP/VA)
	
	tsset cross year
	gen D1_lnEMP 		= D1.lnEMPE *100
	gen D1_lnH_EMP		= D1.lnH_EMPE *100
	gen D1_lnLAB		= D1.lnCOMP *100
	gen D1_lnlaborshare	= D1.lnlaborshare *100
	gen D1_lnhwage 		= D1_lnLAB - D1_lnH_EMP
	
	*Standardize TFP 
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	
	*Recalculate regression weights for employment and hours, to exclude self-employed
	drop weight_h weight_h_c weight weight_c 
	drop EMP H_EMP
	gen EMP=EMPE
	gen H_EMP=H_EMPE
	
	*employment
	bysort country year: egen totemp=sum(EMP) 
	gen empshare=EMP/totemp 
	bysort country code: egen meanempshare=mean(empshare) 
	table country year, c(sum meanem)
	rename meanempshare weight
	label var weight "Industry employment share within countries, averaged over time"
	drop empshare totemp

	*hours
	bysort country year: egen tothemp=sum(H_EMP) 
	gen hempshare=H_EMP/tothemp 
	bysort country code: egen meanhempshare=mean(hempshare) 
	table country year, c(sum meanhem)
	rename meanhempshare weight_h
	label var weight_h "Industry hours worked share within countries, averaged over time"
	drop hempshare tothemp
			
	*Calculate country-size based industry regression weights
	bysort year: egen totEMP=sum(EMP)
	bysort country year: egen totEMPc=sum(EMP)
	gen empshare=totEMPc/totEMP if totEMPc!=0
	gen weight_c=weight*empshare	
	label var weight_c "weight * share of country's EMP in total EMP by year"

	bysort year: egen totHRS=sum(H_EMP)
	bysort country year: egen totHRSc=sum(H_EMP)
	gen hempshare=totHRSc/totHRS if totHRSc!=0
	gen weight_h_c=weight_h*hempshare	
	label var weight_h_c "weight_h * share of country's H_EMP in total H_EMP by year"

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
		
**2. Table 6, panel C
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T6_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T6_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local controls	"i.sectorgroup"


	**Column 1: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls' [w=weight_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui xi:areg D1_lnH_EMP  `own' `controls' [w=weight_h_c], absorb(ct) clus(ic)
			storeestimates

	**Column 3: Nominal wage bill
		global col=3
		qui xi:areg D1_lnLAB  `own'   `controls' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	**Column 4: Nominal value added
		global col=4
		qui xi:areg D1_lnVA  `own' `controls' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column 5: Real value added
		global col=5
		qui xi:areg D1_lnVA_QI  `own' `controls' [w=weight_VA_c], absorb(ct) clus(ic)
			storeestimates
			
	**Column 6: Laborshare
		global col=6
		qui xi:areg D1_lnlaborshare  `own'   `controls' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
			
	*Table
	esttab T6_1 T6_2 T6_3 T6_4 T6_5 T6_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel C")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel C")
		}	
		
		
